<?php

/*
*	addition to the UserForms module to allow HTML sectioning
*/

class EditableEndField extends EditableFormField {

	private static $singular_name = 'End Panel';

	private static $plural_name = 'End Panels';

	public function getFieldConfiguration() {
		$options = parent::getFieldConfiguration();

		$options->push(
			new CheckboxField(
				$this->getSettingName('HideFromReports'),
				_t('EditableLiteralField.HIDEFROMREPORT', 'Hide from reports?'), 
				$this->getSetting('HideFromReports')
			)
		);
		
		return $options;
	}

	public function getIcon() {
		return 'ds-silverstripe-configurable-form/userforms/images/editableliteralfield.png';
	}

  /**
   * @package HTML
   */
	public function getFormField() {
		return new LiteralField("LiteralField[$this->ID]",
			"</div>"
		);
	}

	public function showInReports() {
		return (!$this->getSetting('HideFromReports'));
	}

}
?>