<?php

/**
 * Shows a google map on the front end, allowing the user to move and drag the
 * marker round to select a point then saves this point in a hidden field for
 * the form submission.
 *
 * @package googlemapselectionfield
 */

class EditableStartField extends EditableFormField {

	private static $singular_name = 'Start Panel';

	private static $plural_name = 'Start Panels';

	public function getIcon() {
		return 'ds-silverstripe-configurable-form/userforms/images/editableliteralfield.png';
	}

	public function getFieldConfiguration() {
		$options = parent::getFieldConfiguration();

		$options->merge(new FieldList(
			new TextField(
				"Fields[$this->ID][CustomSettings][CssClass]", _t('EditableFormField.CLASSATTRIBUTE', 'Class Attribute'),
				($this->getSetting('CssClass')) ? $this->getSetting('CssClass') : ''
			),

			new TextField(
				"Fields[$this->ID][CustomSettings][OtherAttributes]", _t('EditableFormField.OTHERATTRIBUTES', 'Other Attributes'),
				($this->getSetting('OtherAttributes')) ? $this->getSetting('OtherAttributes') : ''
			)
    	));


		$options->push(
			new CheckboxField(
				$this->getSettingName('HideFromReports'),
				_t('EditableLiteralField.HIDEFROMREPORT', 'Hide from reports?'), 
				$this->getSetting('HideFromReports')
			)
		);
		
		return $options;
	}

  /**
   * @package HTML
   */
	public function getFormField() {
		return new LiteralField("LiteralField[$this->ID]",
		"<div id='$this->Name' class='".$this->getSetting('CssClass')."' ".$this->getSetting('OtherAttributes').">"
		);
	}

	public function showInReports() {
		return (!$this->getSetting('HideFromReports'));
	}

}
?>