<?php
/**
 * EditableDropdown
 *
 * Represents a modifiable dropdown (select) box on a form
 *
 * @package userforms
 */

class EditableDropdown extends EditableMultipleOptionField {
	
	private static $singular_name = 'Dropdown Field';
	
	private static $plural_name = 'Dropdowns';
	
	/**
	 * @return DropdownField
	 */
	public function getFormField() {	
		$optionSet = $this->Options();
		$options = array();

		if($optionSet) {
			foreach($optionSet as $option) {
				$options[$option->Title] = $option->Title;
			}
		}
		
		return DropdownField::create($this->Name, $this->Title, $options)
			->setEmptyString('-- Select ' . $this->Title . ' --');	
	}
}