<?php
/**
* Module to allow header and footer content to be included for scripts etc 
* 
* @author Hugh Volpe <hugh@daykinandstorey.co.uk>
* 
**/
class IncludesExtension extends DataExtension {
	private static $db = array(
		'IncludesHeaderContent' => 'HTMLText',
		'IncludesFooterContent' => 'HTMLText',
		'ExclusionList' => 'Text',
		'HideOnTesting' => 'Boolean',
		'ByPass' => 'Boolean',
	);

	private static $defaults = array(
		'HideOnTesting' => true,
		'ByPass' => false,
	);

	public function updateCMSFields(FieldList $fields) {

		$fields->addFieldsToTab('Root.Includes', array(
			TextAreaField::create('IncludesHeaderContent' , 'Header Content')->setDescription("Content for insertion in to the header (tracking code, meta etc), will be placed directly in to the header to be careful")->setRows(5),
			TextAreaField::create('IncludesFooterContent' , 'Footer Content')->setDescription("Content for insertion in to the footer, will be placed directly in to the footer (before the closing body tag) to be careful")->setRows(5),
			TextAreaField::create('ExclusionList' , 'Exclusion IP List')->setDescription("A list of IP addresses seperated by comma, IP address which should have Page and Site level header and footer includes removed")->setRows(5),
			CheckboxField::create('HideOnTesting' , 'Hide Content on Testing Mode')->setDescription("Check this box to hide the content when the site is in test mode, development mode, or a user is logged in"),
			CheckboxField::create('ByPass' , 'Bypass')->setDescription("Check this box to ignore all of the previouse settings and just output the content regardless (for testing)"),
		));

	}

}