<?php
/**
*
* Page Includes for Header and footer content placed directly on a page
*
* @author Hugh Volpe <hugh@daykinandstorey.co.uk>
* 
**/
class PageIncludesModelExtension extends DataExtension{

	private static $db = array(
		'IncludesHeaderContent' => 'HTMLText',
		'IncludesFooterContent' => 'HTMLText',	
	);

	public function updateCMSFields(FieldList $fields) {

		$fields->addFieldsToTab('Root.Includes', array(
			TextAreaField::create('IncludesHeaderContent' , 'Header Content')->setDescription("Content for insertion in to the header of THIS PAGE ONLY (tracking code, meta etc), will be placed directly in to the header to be careful")->setRows(5),
			TextAreaField::create('IncludesFooterContent' , 'Footer Content')->setDescription("Content for insertion in to the footer of THIS PAGE ONLY, will be placed directly in to the footer (before the closing body tag) to be careful")->setRows(5),
		));

	}	

}

/**
*
* Controller functions to allow outputting of the includes data
*
* @author Hugh Volpe <hugh@daykinandstorey.co.uk>
* 
**/
class PageIncludesControllerExtension extends Extension{

	/*
	* function to combine decide if we should output the code
	*/
	public function showOrNo(){
		$config = SiteConfig::current_site_config();

		// if we are bypassing just push them back
		if ($config->ByPass == true){
			return true;
		}

		// check if we are logged in or testing/dev
		if($config->HideOnTesting == true){

			if(Member::currentUserID()){
				return false;
			}

			if( Director::isTest() OR Director::isDev() ){
				return false;
			}

			
			//get the list of IPs
			$ips = explode(',', str_replace(' ', '', $config->ExclusionList));
			if(in_array($_SERVER['REMOTE_ADDR'], $ips)){
				return false;
			}

		}

		// no reason not to
		return true;
	}

	/*
	* function to combine the two header includes and return as a string
	*/
	public function IncludesHeader(){
		
		if($this->showOrNo()){
			$config = SiteConfig::current_site_config();
			return $config->IncludesHeaderContent . $this->owner->IncludesHeaderContent;
		} 

		return false;

	}

	/*
	* function to combine the two footer includes and return as a string
	*/
	public function IncludesFooter(){
	
		if($this->showOrNo()){		
			$config = SiteConfig::current_site_config();
			return $config->IncludesFooterContent . $this->owner->IncludesFooterContent;
		} 

		return false;
	}	
	



}