<?php
/*
* Controller to handle http request for the robots.txt file
* 404 if no data present
* To Do: cache?
*/

class RobotsController extends Controller {

	private static $allowed_actions = array(
		'index'
	);

	public function index(SS_HTTPRequest $request) {
		
		$config = SiteConfig::current_site_config();

		// Check if there is any data to return. 404 instead if not
		if(!$config->RobotsText OR $config->RobotsText == ''){
			return $this->httpError(404, "Not Found");
		}

		// Return the robots.txt file
        $response = new SS_HTTPResponse($config->RobotsText);
        $response->addHeader('Cache-Control', 'no-cache, max-age=0, must-revalidate, no-transform');
		$response->addHeader('Content-Type', 'text/html; charset=utf-8');
		$response->addHeader('Content-Length', strlen($config->RobotsText));
        
		return $response;
	}

}