<?php
/**
* Allow editing of robots.txt file, store the data in the site config
* 
* 
* TO DO: 
*  - Add version control
*  - Check for SiteMap and add if so
*  - Set a default good setup for silverstripe
*  - Allow setting from a page, like sitemaps
**/
class RobotsExtension extends DataExtension {

	private static $db = array(
		'RobotsText' => 'HTMLText',
	);

	/* Create admin area */
	public function updateCMSFields(FieldList $fields) {

		// Check if they have a static file already
		if($this->RobotsTxtExists()){
			$fields->addFieldsToTab('Root.Robots',
				LiteralField::create('RobotAlert','<h3 style="color: red;">You already have a static Robots.txt file. Please delete it to use this module</h3>')
			);		
		}
		else{
			$robotsField = TextareaField::create('RobotsText' , 'Robots.txt File Contents')
				->setDescription("Directly edit Robots.txt")
				->setRows(30);

			$fields->addFieldsToTab('Root.Robots', array(
				$robotsField,
				LiteralField::create('RobotDesc','Not sure what to write? <a href="https://developers.google.com/webmasters/control-crawl-index/docs/robots_txt?hl=en">Google on Robots.txt</a>')
			));	
		}


	}

	/* Do we currently have a robots.txt file */
	public function RobotsTxtExists(){

		if( file_exists(BASE_PATH . '/robots.txt') OR file_exists(BASE_PATH . '/Robots.txt')){
			return true;
		}
		return false;
	
	}

}