<?php
class Address extends DataObject {
  private static $db = array(
    'PhoneNumber' => 'varchar',
    'AddressDownloadText' => 'varchar',
    'EmbedCode' => 'HTMLText'
  );
  function getTitle(){
    return $this->getFullAddress();
  }
  private static $has_one = array(
    'AddressDownloadLink' => 'File'
  );
  private static $belongs_many_many = array(
    'SiteConfigs' => 'SiteConfig'
  );
  public function getCMSFields(){
    $fields = parent::getCMSFields();
    $fields->addFieldToTab('Root.Address',TextField::create('PhoneNumber'));
    $fields->addFieldToTab('Root.Address',$AddressLink = UploadField::create('AddressDownloadLink', 'Address PDF Link'));
    $fields->addFieldToTab('Root.Address',TextField::create('AddressDownloadText', 'Address PDF Text')
            ->setDescription('Text used for pdf link, if left blank it will auto to the title of the file')
    );
    $fields->addFieldToTab('Root.Address',TextAreaField::create('EmbedCode'));

    $AddressLink
      ->setFolderName('DownloadLinks')
      ->getValidator()->setAllowedExtensions(array('pdf'));

    $fields->removeByName("SiteConfigs");
    $fields->removeByName("Main");
    return $fields;
  }
  private static $summary_fields = array(
    'Address',
    'Suburb',
    'State',
    'Postcode',
    'PhoneNumber'
  );
  private static $searchable_fields = array(
    'Address',
    'Suburb',
    'State',
    'Postcode',
    'PhoneNumber'
  );
  public function getGoogleLink(){
    if ($this->getFullAddress()){
      $GoogleLink = "https://www.google.co.uk/maps/search/".str_replace(" ","+", $this->getFullAddress());
      return $GoogleLink;
    }
  }
}