<?php
class BlogEntryExtension extends DataExtension {
  private static $many_many = array(
    'Treatments' => 'Treatment',
  );
  public static $many_many_extraFields = array(
    'Treatments' => array(
      'SortOrder' => 'Int'
    )
  );
  public function Treatments() {
    $owner = $this->owner;
    return $owner->getManyManyComponents('Treatment')->sort('SortOrder');
  }

  public function updateCMSFields(FieldList $fields) {
    $owner = $this->owner;

    $gridfieldconfig = gridfieldconfig_relationeditor::create();
    $gridfieldconfig->removecomponentsbytype('gridfieldaddnewbutton');
    $gridfieldconfig->removecomponentsbytype('gridfieldeditbutton');
    $gridfieldconfig->addComponent(new GridFieldSortableRows('SortOrder'));
    $gridfield = new gridfield("Treatments", "Treatments", $owner->Treatments()->sort("SortOrder"), $gridfieldconfig);
    $fields->addFieldToTab('Root.Treatments', $gridfield);

    }
}