<?php
class SiteConfigExtension extends DataExtension {
  private static $db = array(
    'FooterText' => 'HTMLText',
    'CopyrightText' => 'HTMLText',
    'TreatmentSaverEmbedCode' => 'HTMLText',
    'Facebook' => 'Varchar(100)',
    'Twitter' => 'Varchar(100)',
    'Youtube' => 'Varchar(100)',
  );
  private static $has_one = array(
    'CompanyLogo' => 'Image'
  );
  private static $many_many = array(
    'MainNavigation' => 'Page',
    'HeaderNavigation' => 'Page',
    'FooterNavigation' => 'Page',
    'Addresses' => 'Address'
  );
  public static $many_many_extraFields = array(
    'MainNavigation' => array(
      'SortOrder' => 'Int'
    ),
    'Addresses' => array(
      'SortOrder' => 'Int'
    ),
    'HeaderNavigation' => array(
      'SortOrder' => 'Int'
    ),
    'FooterNavigation' => array(
      'SortOrder' => 'Int'
    )
  );
  public function MainNavigation() {
    return $this->getManyManyComponents('Page')->sort('SortOrder');
  }
  public function Addresses() {
    $owner = $this->owner;
    return $owner->getManyManyComponents('Addresses')->sort('SortOrder');
  }
  public function HeaderNavigation() {
    return $this->getManyManyComponents('Page')->sort('SortOrder');
  }
  public function FooterNavigation() {
    return $this->getManyManyComponents('Page')->sort('SortOrder');
  }

  public function updateCMSFields(FieldList $fields) {
    $fields->addFieldToTab('Root.Main',UploadField::create('CompanyLogo','Company Logo'), 'Title');
    $fields->addFieldToTab('Root.Main',HTMLEditorField::create('FooterText'));
    $fields->addFieldToTab('Root.Main',HTMLEditorField::create('CopyrightText'));

    $fields->addFieldToTab('Root.Social',TextField::create('Facebook'));
    $fields->addFieldToTab('Root.Social',TextField::create('Twitter'));
    $fields->addFieldToTab('Root.Social',TextField::create('Youtube'));

    $owner = $this->owner;
    $HeaderConfig = gridfieldconfig_relationeditor::create();
    $HeaderConfig->removecomponentsbytype('gridfieldaddnewbutton');
    $HeaderConfig->removecomponentsbytype('gridfieldeditbutton');
    $HeaderConfig->addComponent(new GridFieldSortableRows('SortOrder'));
    $gridfield = new gridfield("HeaderNavigation", "Header Navigation", $owner->HeaderNavigation()->sort("SortOrder"), $HeaderConfig);
    $fields->addFieldToTab('Root.HeaderNavigation', $gridfield);

    $MainConfig = gridfieldconfig_relationeditor::create();
    $MainConfig->removecomponentsbytype('gridfieldaddnewbutton');
    $MainConfig->removecomponentsbytype('gridfieldeditbutton');
    $MainConfig->addComponent(new GridFieldSortableRows('SortOrder'));
    $gridfield = new gridfield("MainNavigation", "Main Navigation", $owner->MainNavigation()->sort("SortOrder"), $MainConfig);
    $fields->addFieldToTab('Root.MainNavigation', $gridfield);

    $FooterConfig = gridfieldconfig_relationeditor::create();
    $FooterConfig->removecomponentsbytype('gridfieldaddnewbutton');
    $FooterConfig->removecomponentsbytype('gridfieldeditbutton');
    $FooterConfig->addComponent(new GridFieldSortableRows('SortOrder'));
    $gridfield = new gridfield("FooterNavigation", "Footer Navigation", $owner->FooterNavigation()->sort("SortOrder"), $FooterConfig);
    $fields->addFieldToTab('Root.FooterNavigation', $gridfield);
    $fields->addFieldToTab('Root.FooterNavigation', LiteralField::create('info' , 'Up to a maximum of 8 links will be shown to preserve layout. The first 4 links will be displayed in the left, last 4 in the right'));

    $config = GridFieldConfig_RelationEditor::create();
    $config->addComponent(new GridFieldSortableRows('SortOrder'));
    $AddressesGF = new GridField('Addresses', 'Addresses', $this->Addresses(), $config);
    $fields->addFieldToTab('Root.Addresses', $AddressesGF);
    $fields->addFieldToTab('Root.Main', TextAreaField::create('TreatmentSaverEmbedCode'));

    }
}