<?php
class HomePage extends Page {
  private static $db = array(
  	'ArticleHeader' => 'varchar',
  	'ArticleSubHeader' => 'varchar',    
  );
  private static $many_many = array(
    'FeaturedTreatments' => 'FeaturedTreatment',
    'Slides' => 'Slide'
  );
  private static $has_one = array(
    'BlogSideImage' => 'Image',
    'BlogSideImageLink' => 'SiteTree',
    'ArticleImg' => 'Image',
  );

  public function getCMSFields(){
    $fields = parent::getCMSFields();
    $slidesConfig = GridFieldConfig_RelationEditor::create();
    $FeaturedTreatmentsGF = new GridField('FeaturedTreatments', 'Featured Treatments', $this->FeaturedTreatments(), $slidesConfig);
    $fields->addFieldToTab('Root.FeaturedTreatments', $FeaturedTreatmentsGF);

    $TreatmentConfig = GridFieldConfig_RelationEditor::create();
    $SlidesGF = new GridField('Slides', 'Slides', $this->Slides(), $TreatmentConfig);
    $fields->addFieldToTab('Root.Slides', $SlidesGF);
    $fields->removeByName('Header');
    $fields->addFieldToTab('Root.Main', TextField::create('ArticleHeader', 'Article Header')->SetDescription('This will appear in an H1 tag for the home page'), 'Content'); 
    $fields->addFieldToTab('Root.Main', TextField::create('ArticleSubHeader', 'Article SubHeader')->SetDescription('This will appear in an H2 tag for the home page'), 'Content');        
    $fields->addFieldToTab('Root.Main', UploadField::create('ArticleImg') , 'Content');    
    $fields->addFieldToTab('Root.Main', UploadField::create('BlogSideImage'));
    $fields->addFieldToTab('Root.Main', DropdownField::create('BlogSideImageLinkID', 'BlogSideImageLink', SiteTree::get()->map('ID','Title')));
    $fields->addFieldToTab('Root.Main', TextAreaField::create('TreatmentSaverEmbedCode'));
    return $fields;

  }
  public function BlogEntries(){
    if (BlogHolder::get()->exists()){
      $BlogHolder=BlogHolder::get()->First();
      return $BlogHolder->Entries(4);
    }
  }
}
class HomePage_Controller extends Page_Controller {

  private static $allowed_actions = array (
  );

  public function init() {
    parent::init();
  }
}
