<?php
class Page extends SiteTree {

  private static $db = array(
    'HeaderTitle' => 'Varchar',
    'HeaderContent' => 'Text',
    'MetaTitle' => 'Varchar(100)',
    'RedirectToChildOne' => 'Boolean'
  );
  private static $has_one = array(
    'Header' => 'Image'
  );
	private static $belongs_many_many = array(
    'SiteConfig' => 'SiteConfig'
  );

  public function getCMSFields(){
    $fields = parent::getCMSFields();
    $fields->addFieldToTab('Root.Header', UploadField::create('Header','Header Image'));
    $fields->addFieldToTab('Root.Header', TextField::create('HeaderTitle','Header Title'));
    $fields->addFieldToTab('Root.Header', TextAreaField::create('HeaderContent','Header Content'));
    $fields->addFieldToTab('Root.Main', TextField::create('MetaTitle','Meta Title'), 'MetaDescription');
    $fields->addFieldToTab('Root.Main', CheckboxField::create("RedirectToChildOne", "Redirect to first available child of this page, if any."), "MenuTitle");
    return $fields;
  }
  public function ProcedureChildren(){
    $Children = SiteTree::get()->filter(array('ClassName' => array('Procedure','VirtualPage'),'ParentID' => $this->ID ));
    return $Children;
  }
  public function TreatmentChildren(){
    $Children = SiteTree::get()->filter(array('ClassName' => array('Treatment','VirtualPage','TreatmentCategory'),'ParentID' => $this->ID ));
    return $Children;
  }
  public function getGroupedProcedureChildren() {
    return GroupedList::create($this->ProcedureChildren()->sort('Title'));
  }
  public function getGroupedTreatmentChildren() {
    return GroupedList::create($this->TreatmentChildren()->sort('Title'));
  }
  public function RandomTestimonials(){
    if($Random = Testimonial::get()->sort('RAND()')->First()){
      return $Random;
    }
    
  }
  public function CustomBreadcrumbs($maxDepth = 20, $unlinked = false, $stopAtPageType = false, $showHidden = false) {
    $page = $this;
    $pages = array();
    
    while(
      $page  
      && (!$maxDepth || count($pages) < $maxDepth) 
      && (!$stopAtPageType || $page->ClassName != $stopAtPageType)
    ) {
      if($showHidden || $page->ShowInMenus || ($page->ID == $this->ID)) { 
        $pages[] = $page;
      }
      
      $page = $page->Parent;
    }
    
    $template = new SSViewer('CustomBreadcrumbsTemplate');
    
    return $template->process($this->customise(new ArrayData(array(
      'Pages' => new ArrayList(array_reverse($pages))
    ))));
  }
}
class Page_Controller extends ContentController {

	/**
	 * An array of actions that can be accessed via a request. Each array element should be an action name, and the
	 * permissions or conditions required to allow the user to access it.
	 *
	 * <code>
	 * array (
	 *     'action', // anyone can access this action
	 *     'action' => true, // same as above
	 *     'action' => 'ADMIN', // you must have ADMIN permissions to access this action
	 *     'action' => '->checkAction' // you can only access this action if $this->checkAction() returns true
	 * );
	 * </code>
	 *
	 * @var array
	 */
	private static $allowed_actions = array (
	);

  public function init() {
  	if($this->RedirectToChildOne) {
		if($firstChild = $this->Children()->First()) {
			$this->redirect($firstChild->Link(), '301');
		}
	}
    return parent::init();
  }

}
