<?php
class Procedure extends Page {

  private static $db = array(
    'ProcedureContactText' => 'HTMLText'
  );

  private static $many_many = array(
    'ProcedureCategory' => 'ProcedureCategory'
  );
  private static $belongs_many_many = array(
    'Testimonial' => 'Testimonial'
  );

  public function getCMSFields(){
    $fields = parent::getCMSFields();
    $config = GridFieldConfig_RelationEditor::create();
    $ProcedureCategoryGF = new GridField('ProcedureCategory', 'Category', $this->ProcedureCategory(), $config);
    $fields->addFieldToTab('Root.Main', $ProcedureCategoryGF);
 
    $ProcedureCategoryCTA = new TextField('ProcedureContactText', 'Procedure CTA Text');
    $ProcedureCategoryCTA->setDescription('Enter text to appear in the Call to Action on this Procedure, use &lt;em&gt;text&lt;/em&gt; to emphasise words. This link will always go to Contact-Us page.');
    $fields->addFieldToTab('Root.Main', $ProcedureCategoryCTA , 'Content');
    return $fields;

  }
  public function ProcedureCategoryTitle(){
    if($this->ProcedureCategory()->exists()){
      foreach($this->ProcedureCategory() as $ProcedureCategory){
        return $ProcedureCategory->Title;
      }
    }
  }
  public function getTitleFirstLetter() {
    return $this->Title[0];
  }
}
class Procedure_Controller extends Page_Controller {

  private static $allowed_actions = array (
  );

  public function init() {
    parent::init();
  }
}
