<?php
/**
 * @package mysite
 * @subpackage tasks
 */
class ImportRedirects extends BuildTask
{
    /** Flag to control whether or not to overwrite exisiting entities */
    const REPLACE = false;

    /** Print debug flag */
    const DEBUG = true;

    private $defaultCategoryType;

    private static $allowed_actions = array(
        '*' => 'ADMIN'
    );

    protected $title = 'Import Redirects';

    protected $description = 'Import redirects from supplied sheet';

    protected $header;

    /**
     * @param $request
     * @throws ValidationException
     */
    public function run($request)
    {
        // Increase execution lime limit
        increase_time_limit_to();

        error_reporting(-1);

        // Add all redirects to array
        $csvFile = file('../redirects.csv');
        $data = [];
        foreach ($csvFile as $line) {
            $data[] = str_getcsv($line);
        }

        array_shift($data);

        $counter = 0;

        // create redirects
        foreach ($data as $k => $v) {
            $redirectURL = new RedirectedURL();
            $redirectURL->FromBase = $v[0];
            $redirectURL->To = $v[1];
            $redirectURL->write();
            $counter++;
        }

        echo $counter . ' redirects imported';

    }

    /**
     * Output debug wrapper function
     *
     * @param $message
     * @param bool $fatal
     * @throws Exception
     */
    private static function debug($message, $fatal = false)
    {
        // Kill the script and display error regardless of debug flag
        if ($fatal) {
            throw new Exception($message);
        }

        if (true === self::DEBUG) {
            if ($_SERVER['DOCUMENT_ROOT'] == '') {
                echo $message . PHP_EOL;
            } else {
                echo "<pre>$message</pre>";
                ob_flush();
                flush();
            }
        }
    }
}