<% if Slides %>
  <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
    <!-- Wrapper for slides -->
    <div class="carousel-inner">
      <% loop Slides %>
        <div class="item<% if First %> active<% end_if %>">
          <img src="$Image.URL" alt="$Title">
          <div class="carousel-caption">
            <div class="slide-title">$Title</div>
            <div class="slide-content">$Content</div>
            <a href="{$Page.Link}" class="header-button slide-button" onclick="ga('send', 'event', 'Click', '$Title - homepage', '$Title - homepage')">$ButtonText</a>
          </div>
        </div>
      <% end_loop %>
    </div>
    <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
      <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
      <span class="sr-only">Previous</span>
    </a>
    <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
      <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
      <span class="sr-only">Next</span>
    </a>
    <ol class="carousel-indicators">
    <% loop Slides %>
      <li data-target="#carousel-example-generic" data-slide-to="$Pos(0)" class="<% if First %>active<% end_if %>"></li>
    <% end_loop %>
    </ol>
  </div>
<% end_if %>
  <% if ArticleHeader %>
  <div class="row feature-article">
  	<div class="col-md-6">
  	  <% if ArticleImg %>
      $ArticleImg.SetWidth(720)
      <% end_if %>
  	</div>

    
  	<article class="col-md-6">
  		<h1>$ArticleHeader</h1>
  		<h2>$ArticleSubHeader</h2>
  		$Content
  	</article> 
  </div>
  <% end_if %>

<% if FeaturedTreatments %>
</div>
<div class="container-fluid featured-treatment-background">
  <div class="container">
    <div class="row">
      <h2 class="treatment-title">Some of our most popular cosmetic treatments</h2>
      <% loop FeaturedTreatments %>
        <div class="col-lg-3 col-md-3 col-sm-3 sm-t treatment $EvenOdd">
          <a href="$Page.Link" onclick="ga('send', 'event', 'Click', '$Title - homepage', '$Title - homepage')">
            <h2>$Title</h2>
            $Image
          </a>            
            $Content

        </div>
      <% end_loop %>
    </div>
  </div>
</div>
<div class="container">
<% end_if %>
<% if BlogEntries %>
<div class="row">
  <div class="col-lg-7 col-md-7 col-sm-7">
    <h2 class="latest-title">Latest from our blog</h2>
    <% loop BlogEntries %>
      <a href="$Link" class="blog-link">$Title</a>
    <% end_loop %>
  </div>
  <div class="col-lg-5 col-md-5 col-sm-5 contain">
   <% if BlogSideImageLink %>
   <a href="$BlogSideImageLink.Link" title="Go to $Title" onclick="ga('send', 'event', 'Click', 'Treatment video library - homepage', 'Treatment video library - homepage')">
   <% end_if %>
   $BlogSideImage
    <% if BlogSideImageLink %>
   </a>
   <% end_if %>
  </div>
</div>
<% end_if %>